;************************************************************************
;*	Register memory mapping file for 16f877	
;*	by kfw						
;************************************************************************

;main registers
w			equ	0x00		;data to w register
f			equ	0x01		;data to file register

;bank 0
indf			equ	0x00		;indirect file register
tmr0			equ	0x01		;timer0 register
pcl			equ	0x02		;program counter - low byte
status		equ	0x03		;status register

;status bits --------------------
c			equ	0x00		;carry bit
dc			equ	0x01		;carry/borrow bit
z			equ	0x02		;zero bit
pd			equ	0x03		;power-down bit
to			equ	0x04		;watch-dog time-out bit
rp0			equ	0x05		;bank select bit
rp1			equ	0x06		;bank select bit
irp			equ	0x07		;bank select bit
;--------------------------------

fsr			equ	0x04		;file select register
porta		equ	0x05		;porta register
portb		equ	0x06		;portb register
portc		equ	0x07		;portc register
portd		equ	0x08		;portd register
porte		equ	0x09		;porte register
pclath		equ	0x0a		;write buffer for upper 5-bits of PC
intcon		equ	0x0b		;interrupt control register

;intcon bits --------------------
rbif			equ	0x00		;Portb change interrupt flag
intf			equ	0x01		;RB0/INT external interrupt flag
t0if			equ	0x02		;Timer0 overflow interrpt flag
rbie			equ	0x03		;Portb change interrupt enable
inte			equ	0x04		;RB0/INT external interrupt enable
t0ie			equ	0x05		;Timer0 overflow interrupt enable
peie			equ	0x06		;Peripheral interrupt enable
gie			equ	0x07		;Global interrupt enable
;--------------------------------

pir1			equ	0x0c		;Peripheral interrupts register
				
;pir1 bits ----------------------
tmr1if		equ	0x00		;Timer1 overflow interrupt flag
tmr2if		equ	0x01		;Timer2 to PR2 match interrupt flag
ccp1if		equ	0x02		;CCP1 interrupt flag
sspif		equ	0x03		;SSP interrupt flag
txif			equ	0x04		;USART tx interrupt flag
rcif			equ	0x05		;USART rx interrupt flag
adif			equ	0x06		;ADC interrupt flag
pspif		equ	0x07		;Parallel slave port r/w interrupt flag
;--------------------------------

pir2			equ	0x0d		;Peripheral interrupts register

;pir2 bits ----------------------
ccp2if		equ	0x00		;CCP2 interrupt flag
bclif		equ	0x03		;bus collision interrupt flag
eeif			equ	0x04		;EEPROM write operation interrupt flag
;--------------------------------

tmr1l		equ	0x0e		;Timer1 holding register lsb
tmr1h		equ	0x0f		;Timer1 holding register msb
t1con		equ	0x10		;Timer1 control register
				
;t1con bits ---------------------
tmr1on		equ	0x00
tmr1cs		equ	0x01
t1sync		equ	0x02
t1oscen		equ	0x03
t1ckps0		equ	0x04
t1ckps1		equ	0x05
;--------------------------------

tmr2			equ	0x11		;Timer2 module register

t2con		equ	0x12		;Timer2 control register

;t2con bits ---------------------
t2ckps0		equ	0x00
t2ckps1		equ	0x01
tmr2on		equ	0x02
toutps0		equ	0x03
toutps1		equ	0x04
toutps2		equ	0x05
toutps3		equ	0x06
;--------------------------------

sspbuf		equ	0x13		;Synchronous serial port rx buffer/tx register
sspcon		equ	0x14		;Synchronous serial port control register

;sspcon bits --------------------
sspm0		equ	0x00
sspm1		equ	0x01
sspm2		equ	0x02
sspm3		equ	0x03
ckp			equ	0x04
sspen		equ	0x05
sspov		equ	0x06
wcol			equ	0x07
;--------------------------------
				
ccrp1l		equ	0x15		;Capture/Compare/PWM register1 lsb
ccpr1h		equ	0x16		;Capture/Compare/PWM register1 msb
ccp1con		equ	0x17		;Capture/Compare/PWM control register1

;ccp1con bits -------------------
ccp1m0		equ	0x00
ccp1m1		equ	0x01
ccp1m2		equ	0x02
ccp1m3		equ	0x03
ccp1y		equ	0x04
ccp1x		equ	0x05
;--------------------------------
				
rcsta		equ	0x18

;rcsta bits ---------------------
rx9d			equ	0x00
oerr			equ	0x01
ferr			equ	0x02
adden		equ	0x03
cren			equ	0x04
sren			equ	0x05
rx9			equ	0x06
spen			equ	0x07
;--------------------------------
				
txreg		equ	0x19		;USART transmit data register
rcreg		equ	0x1a		;USART receive data register
ccpr2l		equ	0x1b		;Capture/Compare/PWM register2 lsb
ccpr2h		equ	0x1c		;Capture/Compare/PWM register2 msb
ccp2con		equ	0x1d		;Capture/Compare/PWM control register2

;ccp2con bits -------------------
ccp2m0		equ	0x00
ccp2m1		equ	0x01
ccp2m2		equ	0x02
ccp2m3		equ	0x03
ccp2y		equ	0x04
ccp2x		equ	0x05
;--------------------------------

adresh		equ	0x1e		;ADC result register high byte
adcon0		equ	0x1f		;ADC control register

;adcon0 bits --------------------
adon			equ	0x00
godone		equ	0x02
chs0			equ	0x03
chs1			equ	0x04
chs2			equ	0x05
adcs0		equ	0x06
adcs1		equ	0x07
;--------------------------------
				
;bank 1
opt			equ	0x81		;options register

;option bits --------------------
ps0			equ	0x00		;Timer0 prescaler bits
ps1			equ	0x01
ps2			equ	0x02
psa			equ	0x03		;Timer0 prescaler assignment
t0se			equ	0x04		;Timer0 source edge select
t0cs			equ	0x05		;Timer0 clock source select
intedg		equ	0x06		;Interrupt edge select bit
rbpu			equ	0x07		;Portb pull-up enable
;--------------------------------

trisa		equ	0x85		;porta data direction register
trisb		equ	0x86		;portb data direction register
trisc		equ	0x87		;portc data direction register
trisd		equ	0x88		;portd data direction register
trise		equ	0x89		;porte data direction register
pie1			equ	0x8c		;Periheral interrupt enable register

;pie1 bits ----------------------
tmr1ie		equ	0x00		;Timer1 overflow interrupt enable
tmr2ie		equ	0x01		;Timer2 to PR2 match interrupt enable
ccp1ie		equ	0x02		;CCP1 interrupt enable
sspie		equ	0x03		;SSP interrupt enable
txie			equ	0x04		;USART tx interrupt enable
rcie			equ	0x05		;USART rx interrupt enable
adie			equ	0x06		;ADC interrupt enable
pspie		equ	0x07		;Parallel slave port r/w interrupt enable
;--------------------------------
				
pie2			equ	0x8d		;Peripheral interrupts enable

;pie2 bits ----------------------
ccp2ie		equ	0x00		;CCP2 interrupt enable
bclie		equ	0x03		;bus collision interrupt enable
eeie			equ	0x04		;EEPROM write operation interrupt enable
;--------------------------------

pcon			equ	0x8e		;Power control register

;pcon bits ----------------------
bor			equ	0x00		;brown-out reset status
por			equ	0x01		;power-on reset status
;--------------------------------

sspcon2		equ	0x91

;sspcon2 bits -------------------
sen			equ	0x00
rsen			equ	0x01
pen			equ	0x02
rcen			equ	0x03
acken		equ	0x04
ackdt		equ	0x05
ackstat		equ	0x06
gcen			equ	0x07
;-------------------------------

pr2			equ	0x92		;Timer2 period register
sspadd		equ	0x93		;Synchronous serial port address register
sspstat		equ	0x94		;Synchronous serial port status register

;sspstat bits -------------------
bf			equ	0x00
ua			equ	0x01
rw			equ	0x02
s			equ	0x03
p			equ	0x04
daa			equ	0x05
cke			equ	0x06
smp			equ	0x07
;--------------------------------

txsta		equ	0x98		;Transmit status register

;txsta bits ---------------------
tx9d			equ	0x00
trmt			equ	0x01
brgh			equ	0x02
sync			equ	0x04
txen			equ	0x05
tx9			equ	0x06
csrc			equ	0x07
;--------------------------------
				
spbrg		equ	0x99		;Baud rate generator register
adresl		equ	0x9e		;ADC result register low byte
adcon1		equ	0x9f		;ADC control register

;adcon1 bits --------------------
pcfg0		equ	0x00
pcfg1		equ	0x01
pcfg2		equ	0x02
pcfg3		equ	0x03
;--------------------------------

;bank 2
eedata		equ	0x10c		;EEPROM data register
eeadr		equ	0x10d		;EEPROM address register
eedath		equ	0x10e		;EEPROM data register msb
eeadrh		equ	0x10f		;EEPROM address register msb

;bank 3
eecon1		equ	0x18c		;eeprom control 1 register

;eecon1 bits --------------------
erd			equ	0x00		;read control
ewr			equ	0x01		;write conrol
ewren		equ	0x02		;eeprom write enable
ewrerr		equ	0x03		;eeprom error flag
eepgd		equ	0x07		;program/data eeprom select
;--------------------------------

eecon2		equ	0x19d		;eeprom control 2 register

;configuation word register
;oscillator selection
FOSC_LP		equ	0x0000
FOSC_XT		equ	0x0001
FOSC_HS		equ	0x0002
FOSC_RC		equ	0x0003

;watchdog enable
WDTE_ON		equ	0x0004
WDTE_OFF		equ	0x0000

;power-up timer enable
PWRTE_ON		equ	0x0000
PWRTE_OFF	equ	0x0008

;flash program memory code protection
CP_0000		equ	0x0000
CP_1000		equ	0x0010
CP_1F00		equ	0x0020
CP_OFF		equ	0x0030

;brown-out reset enable
BODEN_ON		equ	0x0040
BODEN_OFF	equ	0x0000

;low-voltage icsp enable
LVP_ON		equ	0x0080
LVP_OFF		equ	0x0000

;data ee memory code protection
CPD_ON		equ	0x0000
CPD_OFF		equ	0x0100

;flash program memory write enable
WRT_ON		equ	0x0200
WRT_OFF		equ	0x0000

;in-circuit debugger
ICD_ON		equ	0x0000
ICD_OFF		equ	0x0800

;flash program memory code protection
;(should be set same as CP)
CP2_0000		equ	0x0000
CP2_1000		equ	0x1000
CP2_1F00		equ	0x2000
CP2_OFF		equ	0x3000
